#Cre un module nomm  MyModule.psm1 
#dans le sous rpertoire MyModule du rpertoire $PathModule

#Affiche dynamiquement le nom du chemin de chargement du module
#Implmente la proprite OnRemove
#Localise,  l'aide d'un fichier de donnes, les messages utiliss dans le code du module

$myPath="C:\Temp"
if (-not (Test-Path  $myPath)) 
{ throw "Le rpertoire n'existe pas: $myPath" }

$PathModule="$myPath\MyModule"
md $PathModule -ErrorAction SilentlyContinue 

@"
#Initialisation
  Import-LocalizedData -BindingVariable MessageTable -Filename MyModuleLocalizedData.psd1 -EA Stop
 `$Name=`$MyInvocation.MyCommand.ScriptBlock.Module.Name
 Write-Host (`$MessageTable.MsgInitialise -F `$Name,`$PSScriptRoot)

function Prive {
  Write-Host "Fonction interne`$MessageTable.MsgMsgFinalise -F `$Name) fore Green
}

#Finalisation
function OnRemoveMyModule {
  Write-Host (`$MessageTable.MsgMsgFinalise -F `$Name) fore Green
}
 #Le code de la proprit 'OnRemove' est appel lors de 
#la suppression du module. 
`$MyInvocation.MyCommand.ScriptBlock.Module.OnRemove = { OnRemoveMyModule }  
"@ > "$PathModule\MyModule.psm1"
