function Test-IsImplementingInterface{
# .ExternalHelp ValidationsArgument-Help.xml
 [CmdletBinding()]    
 param (
   [Parameter(Mandatory = $true,Position=0,
              HelpMessage="The name of the interface type to validate.")]
  [Type] $Interface) 
 
 Write-Debug ($FrmtCall -F $MyInvocation.InvocationName)
 $PipelineObjectInScopeOfCaller=$PSCmdlet.SessionState.PSVariable.Get("_").Value

 $Type=$PipelineObjectInScopeOfCaller.GetType()
 if (!$Interface.IsInterface)
  { Throw ($MessageTable.IsImplementingInterfaceIsNotAnInterface -F $Interface)}
 if (!$Interface.IsAssignableFrom($Type)) 
  { Throw ($MessageTable.IsImplementingInterface -F $Type,$Interface)} 
 $true
}#Test-IsImplementingInterface
