﻿function Test-ServiceStatus{
# .ExternalHelp ValidationsArgument-Help.xml         
 [CmdletBinding()]    
 param (
    [Parameter(Mandatory = $true,Position=0,
               HelpMessage="The name of the service to check.")]
   [string]$InputObject,
    [Parameter(Mandatory = $true,Position=1,
               HelpMessage="The status name to check.")]
   [System.ServiceProcess.ServiceControllerStatus] $Status)
 
 Write-Debug ($FrmtCall -F $MyInvocation.InvocationName)
  #Test le statut du service
 $Service=Get-Service -Name $InputObject -EA SilentlyContinue
 if (!$?)
  {Throw ($MessageTable.ServiceStatusUnknown -F $InputObject)}
 if ($Service.Status -ne $Status)
  {Throw ($MessageTable.ServiceStatus -F $Service.DisplayName,$Service.Name,$Status)}
 $true
}