#Module ValidationsArguments
#Charge les fonctions de validation  partir du rpertoire script
#Problme: l'usage du fichier d'aide ne fonctionne pas :/ 
#Le mcanisme de l'aide semble utiliser des informations spcifiques portes par le script externe et pas par le module 

  Import-LocalizedData -BindingVariable MessageTable -Filename ValidationsArgumentLocalizedData.psd1 -EA Stop

  $Frmt=" : $($MyInvocation.MyCommand.ScriptBlock.Module.Name).{0}"
  $FrmtCall="Call$Frmt"
  $FrmtBegin="Begin$Frmt"
  $FrmtProcess="Process$Frmt"
  $FrmtEnd="End$Frmt"
  
  Write-Debug ("Call module : {0}" -F $MyInvocation.MyCommand.ScriptBlock.Module.Name)
  Write-Debug ("PSScriptRoot : {0}" -F $PSScriptRoot)
  Write-Debug "Contenu du message EVAGlobbing : $($MessageTable.EVAGlobbing)"
  
  #Le type [System.Management.Automation.TypeAccelerators] n'tant pas public
  # $T= [System.Management.Automation.TypeAccelerators] # Renvoi une erreur
  #L'usage suivant ne fonctionne pas :
  # [System.Management.Automation.TypeAccelerators]::Add
  
  #Le type n'est pas public mais certaines de ses mthodes le sont :
  # $T= [psobject].assembly.gettype("System.Management.Automation.TypeAccelerators")
  # $T.GetMembers()|select name,membertype,ispublic,isstatic
  # $T.GetConstructors() #Aucun constructeur public 
  
  #On doit donc obtenir une rfrence sur ce type :
  # $T= [psobject].assembly.gettype("System.Management.Automation.TypeAccelerators") 
  # Puis l'utiliser pour adresser la mthode publique :
  # $T::Add($_.Key,$_.Value)
  
 $acceleratorsType= [psobject].assembly.gettype("System.Management.Automation.TypeAccelerators")   
  # Ajoute un acclrateur locale pour la classe d'exception    
 $ValidationsArgumentsShortCut=@{"VMException"=[System.Management.Automation.ValidationMetadataException]}
 $ValidationsArgumentsShortCut.GetEnumerator()|  
    Foreach {
     Try {
       Write-debug "Add TypeAccelerators $($_.Key) =$($_.Value)"
       $AcceleratorsType::Add($_.Key,$_.Value)
     } Catch [System.Management.Automation.MethodInvocationException]{
       write-Error $_.Exception.Message 
     }
   } 
 add-type -assemblyName "System.ServiceProcess"

function New-ValidationFunction {
 param(         
   [ValidateScript( {Test-PathMustexist })]
   [Parameter(Mandatory = $true)]
  [String] $Path,
    [Parameter(Mandatory = $true)]
    [ValidateNotNullOrEmpty()]
  [String] $FunctionName
 )

 $FName=Join-path $Path "Test-${FunctionName}.ps1"

 $Code1="function Test-$FunctionName {"
 $code2=@'

 #rgle de validation d'argument :
 [CmdletBinding()]    
 param () 
  Write-Debug ($FrmtCall -F $MyInvocation.InvocationName)
  $PipelineObjectInScopeOfCaller=$PSCmdlet.SessionState.PSVariable.Get("_").Value

  $true # La valeur est valide
  
<#
.SYNOPSIS
     Rgle de validation 
     todo
    
.DESCRIPTION

      Rfrence en interne le contenu de la variable $_ dclare dans la porte de l'appelant.
    
.PARAMETER  
      
    

.EXAMPLE
      todo code...
     
     Description
     -----------
     todo 
      
     
.INPUTS  

.OUTPUTS  
     Une valeur boolenne, true indiquant que la validation a russie.
     
.FUNCTIONALITY
     ValidationArgument
      
.COMPONENT  
     PowerShell
     
.ROLE   
     SoftwareDeveloper
     
.LINK
     
#>
}
'@ 

 $code1,$code2 > "$FName"
 Write-verbose "Fonction cr : $FName"        
}#New-ValidationFunction

# ----------- Suppression des objets du Wrapper -------------------------------------------------------------------------
function OnRemoveValidationArguments {
  Write-Debug ($FrmtCall -F $MyInvocation.InvocationName)
    #Remove shortcuts
  $ValidationsArgumentsShortCut.GetEnumerator()|
   Foreach {
     Try {
       Write-debug "Remove TypeAccelerators $($_.Key)"
       [void]$AcceleratorsType::Remove($_.Key)
     } Catch {
       write-Error $_.Exception.Message
     }
   }
}
 #Le dlgu de l'vnement 'OnRemove' est appel lors de la suppression du module. 
$MyInvocation.MyCommand.ScriptBlock.Module.OnRemove = { OnRemoveValidationArguments } 
  

# ------------- Scripts externes
$ScriptsPath="$PSScriptRoot\Scripts"
$Local:Scripts=Get-Childitem $ScriptsPath|Where {$_.Extension -eq '.ps1'}
if ($Local:Scripts -ne $null)
{
   Write-Verbose "`n`rImport des scripts externes du rpertoire :`r`n $ScriptsPath"
   $Local:FName=""
   $ExportedFunctions=$Local:Scripts|
     Foreach {
        try{ 
          $Local:FName=split-path $_.Fullname -leaf
          Write-Verbose "$FName " 
           # Charge le code de la function dans la porte du module
          . $_.Fullname
           #Fonction  exporter
          Write-Verbose "$($_.Name)"
          $_.Name -replace '.ps1$',""
        } catch { 
          #[System.Management.Automation.PSSecurityException]
         throw "Chargement impossible du fichier : $(split-path $FName -leaf)`r`n$_ "
        }
    }
}
else {Write-Verbose "`n`rAucun scripts externes."}  

$ExportedFunctions +="New-ValidationFunction"

Export-ModuleMember -Function $ExportedFunctions
Remove-Variable Scripts,FName,ExportedFunctions